// Objective-C API for talking to gitlab.com/elixxir/client/bindings Go package.
//   gobind -lang=objc gitlab.com/elixxir/client/bindings
//
// File is generated by gobind. Do not edit.

#ifndef __Bindings_H__
#define __Bindings_H__

@import Foundation;
#include "ref.h"
#include "Universe.objc.h"


@class BindingsAuthenticatedConnection;
@class BindingsBackup;
@class BindingsBackupReport;
@class BindingsBroadcastMessage;
@class BindingsBroadcastReport;
@class BindingsChannel;
@class BindingsChannelDef;
@class BindingsCmix;
@class BindingsConnection;
@class BindingsDummyTraffic;
@class BindingsE2ESendReport;
@class BindingsE2e;
@class BindingsEventReport;
@class BindingsFilePartTracker;
@class BindingsFileSend;
@class BindingsFileTransfer;
@class BindingsGroup;
@class BindingsGroupChat;
@class BindingsGroupChatMessage;
@class BindingsGroupReport;
@class BindingsGroupSendReport;
@class BindingsMessage;
@class BindingsNodeRegistrationReport;
@class BindingsNotificationReport;
@class BindingsProgress;
@class BindingsReceivedFile;
@class BindingsReceptionIdentity;
@class BindingsRestlikeMessage;
@class BindingsRoundsList;
@class BindingsSingleUseCallbackReport;
@class BindingsSingleUseResponseReport;
@class BindingsSingleUseSendReport;
@class BindingsUserDiscovery;
@protocol BindingsAuthCallbacks;
@class BindingsAuthCallbacks;
@protocol BindingsBroadcastListener;
@class BindingsBroadcastListener;
@protocol BindingsClientError;
@class BindingsClientError;
@protocol BindingsFileTransferReceiveProgressCallback;
@class BindingsFileTransferReceiveProgressCallback;
@protocol BindingsFileTransferSentProgressCallback;
@class BindingsFileTransferSentProgressCallback;
@protocol BindingsGroupChatProcessor;
@class BindingsGroupChatProcessor;
@protocol BindingsGroupRequest;
@class BindingsGroupRequest;
@protocol BindingsListener;
@class BindingsListener;
@protocol BindingsLogWriter;
@class BindingsLogWriter;
@protocol BindingsMessageDeliveryCallback;
@class BindingsMessageDeliveryCallback;
@protocol BindingsNetworkHealthCallback;
@class BindingsNetworkHealthCallback;
@protocol BindingsProcessor;
@class BindingsProcessor;
@protocol BindingsReceiveFileCallback;
@class BindingsReceiveFileCallback;
@protocol BindingsReporterFunc;
@class BindingsReporterFunc;
@protocol BindingsRestlikeCallback;
@class BindingsRestlikeCallback;
@protocol BindingsSingleUseCallback;
@class BindingsSingleUseCallback;
@protocol BindingsSingleUseResponse;
@class BindingsSingleUseResponse;
@protocol BindingsStopper;
@class BindingsStopper;
@protocol BindingsTrackServicesCallback;
@class BindingsTrackServicesCallback;
@protocol BindingsUdLookupCallback;
@class BindingsUdLookupCallback;
@protocol BindingsUdNetworkStatus;
@class BindingsUdNetworkStatus;
@protocol BindingsUdSearchCallback;
@class BindingsUdSearchCallback;
@protocol BindingsUpdateBackupFunc;
@class BindingsUpdateBackupFunc;

@protocol BindingsAuthCallbacks <NSObject>
- (void)confirm:(NSData* _Nullable)contact receptionId:(NSData* _Nullable)receptionId ephemeralId:(int64_t)ephemeralId roundId:(int64_t)roundId;
- (void)request:(NSData* _Nullable)contact receptionId:(NSData* _Nullable)receptionId ephemeralId:(int64_t)ephemeralId roundId:(int64_t)roundId;
- (void)reset:(NSData* _Nullable)contact receptionId:(NSData* _Nullable)receptionId ephemeralId:(int64_t)ephemeralId roundId:(int64_t)roundId;
@end

@protocol BindingsBroadcastListener <NSObject>
- (void)callback:(NSData* _Nullable)p0 p1:(NSError* _Nullable)p1;
@end

@protocol BindingsClientError <NSObject>
- (void)report:(NSString* _Nullable)source message:(NSString* _Nullable)message trace:(NSString* _Nullable)trace;
@end

@protocol BindingsFileTransferReceiveProgressCallback <NSObject>
/**
 * Callback is called when a file part is sent or an error occurs.

Parameters:
 - payload - the JSON marshalled bytes of a Progress object.
 - t - tracker that allows the lookup of the status of any file part
 - err - any errors that occurred during sending
 */
- (void)callback:(NSData* _Nullable)payload t:(BindingsFilePartTracker* _Nullable)t err:(NSError* _Nullable)err;
@end

@protocol BindingsFileTransferSentProgressCallback <NSObject>
/**
 * Callback is called when a file part is sent or an error occurs.

Parameters:
 - payload - the JSON marshalled bytes of a Progress object.
 - t - tracker that allows the lookup of the status of any file part
 - err - any errors that occurred during sending
 */
- (void)callback:(NSData* _Nullable)payload t:(BindingsFilePartTracker* _Nullable)t err:(NSError* _Nullable)err;
@end

@protocol BindingsGroupChatProcessor <NSObject>
- (void)process:(NSData* _Nullable)decryptedMessage msg:(NSData* _Nullable)msg receptionId:(NSData* _Nullable)receptionId ephemeralId:(int64_t)ephemeralId roundId:(int64_t)roundId err:(NSError* _Nullable)err;
- (NSString* _Nonnull)string;
@end

@protocol BindingsGroupRequest <NSObject>
- (void)callback:(BindingsGroup* _Nullable)g;
@end

@protocol BindingsListener <NSObject>
/**
 * Hear is called to receive a message in the UI.

Parameters:
 - item - JSON marshalled Message object
 */
- (void)hear:(NSData* _Nullable)item;
/**
 * Name returns a name; used for debugging.
 */
- (NSString* _Nonnull)name;
@end

@protocol BindingsLogWriter <NSObject>
- (void)log:(NSString* _Nullable)p0;
@end

@protocol BindingsMessageDeliveryCallback <NSObject>
- (void)eventCallback:(BOOL)delivered timedOut:(BOOL)timedOut roundResults:(NSData* _Nullable)roundResults;
@end

@protocol BindingsNetworkHealthCallback <NSObject>
- (void)callback:(BOOL)p0;
@end

@protocol BindingsProcessor <NSObject>
- (void)process:(NSData* _Nullable)message receptionId:(NSData* _Nullable)receptionId ephemeralId:(int64_t)ephemeralId roundId:(int64_t)roundId;
- (NSString* _Nonnull)string;
@end

@protocol BindingsReceiveFileCallback <NSObject>
/**
 * Callback is called when a new file transfer is received.

Parameters:
 - payload - the JSON marshalled bytes of a ReceivedFile object.
 - err - any errors that occurred during reception
 */
- (void)callback:(NSData* _Nullable)payload err:(NSError* _Nullable)err;
@end

@protocol BindingsReporterFunc <NSObject>
- (void)report:(NSData* _Nullable)payload err:(NSError* _Nullable)err;
@end

@protocol BindingsRestlikeCallback <NSObject>
- (void)callback:(NSData* _Nullable)p0 p1:(NSError* _Nullable)p1;
@end

@protocol BindingsSingleUseCallback <NSObject>
- (void)callback:(NSData* _Nullable)callbackReport err:(NSError* _Nullable)err;
@end

@protocol BindingsSingleUseResponse <NSObject>
- (void)callback:(NSData* _Nullable)responseReport err:(NSError* _Nullable)err;
@end

@protocol BindingsStopper <NSObject>
- (void)stop;
@end

@protocol BindingsTrackServicesCallback <NSObject>
- (void)callback:(NSData* _Nullable)marshalData err:(NSError* _Nullable)err;
@end

@protocol BindingsUdLookupCallback <NSObject>
- (void)callback:(NSData* _Nullable)contactBytes err:(NSError* _Nullable)err;
@end

@protocol BindingsUdNetworkStatus <NSObject>
/**
 * UdNetworkStatus returns:
- int - a xxdk.Status int
 */
- (long)udNetworkStatus;
@end

@protocol BindingsUdSearchCallback <NSObject>
- (void)callback:(NSData* _Nullable)contactListJSON err:(NSError* _Nullable)err;
@end

@protocol BindingsUpdateBackupFunc <NSObject>
- (void)updateBackup:(NSData* _Nullable)encryptedBackup;
@end

@interface BindingsAuthenticatedConnection : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
// skipped field AuthenticatedConnection.Connection with unsupported type: gitlab.com/elixxir/client/bindings.Connection

- (BOOL)close:(NSError* _Nullable* _Nullable)error;
- (long)getId;
- (NSData* _Nullable)getPartner;
- (BOOL)isAuthenticated;
- (BOOL)registerListener:(long)messageType newListener:(id<BindingsListener> _Nullable)newListener error:(NSError* _Nullable* _Nullable)error;
- (NSData* _Nullable)sendE2E:(long)mt payload:(NSData* _Nullable)payload error:(NSError* _Nullable* _Nullable)error;
@end

/**
 * Backup is a bindings-level struct encapsulating the backup.Backup
client object.
 */
@interface BindingsBackup : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
/**
 * AddJson stores the argument within the Backup structure.

Params
 - json - JSON string
 */
- (void)addJson:(NSString* _Nullable)json;
/**
 * IsBackupRunning returns true if the backup has been initialized and is
running. Returns false if it has been stopped.
 */
- (BOOL)isBackupRunning;
/**
 * StopBackup stops the backup processes and deletes the user's password from
storage. To enable backups again, call InitializeBackup.
 */
- (BOOL)stopBackup:(NSError* _Nullable* _Nullable)error;
@end

/**
 * BackupReport is the bindings' representation of the return values of
NewCmixFromBackup.

Example BackupReport:
 {
   "RestoredContacts": [
     "U4x/lrFkvxuXu59LtHLon1sUhPJSCcnZND6SugndnVID",
     "15tNdkKbYXoMn58NO6VbDMDWFEyIhTWEGsvgcJsHWAgD"
   ],
   "Params": ""
 }
 */
@interface BindingsBackupReport : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
// skipped field BackupReport.RestoredContacts with unsupported type: []*gitlab.com/xx_network/primitives/id.ID

/**
 * The backup parameters found within the backup file
 */
@property (nonatomic) NSString* _Nonnull params;
@end

/**
 * BroadcastMessage is the bindings representation of a broadcast message.

BroadcastMessage Example JSON:
 {
	 "RoundID":42,
  "EphID":[0,0,0,0,0,0,24,61],
  "RoundURL":"https://dashboard.xx.network/rounds/25?xxmessenger=true",
  "Payload":"SGVsbG8sIGJyb2FkY2FzdCBmcmllbmRzIQ=="
 }
 */
@interface BindingsBroadcastMessage : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
// skipped field BroadcastMessage.BroadcastReport with unsupported type: gitlab.com/elixxir/client/bindings.BroadcastReport

@property (nonatomic) NSData* _Nullable payload;
- (NSData* _Nullable)marshal:(NSError* _Nullable* _Nullable)error;
@end

/**
 * BroadcastReport is the bindings representation of the info on how a broadcast
message was sent

BroadcastReport Example JSON:
 {
	 "Rounds": [25, 26, 29],
  "EphID":[0,0,0,0,0,0,24,61],
  "RoundURL":"https://dashboard.xx.network/rounds/25?xxmessenger=true"
 }
 */
@interface BindingsBroadcastReport : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
// skipped field BroadcastReport.RoundsList with unsupported type: gitlab.com/elixxir/client/bindings.RoundsList

@property (nonatomic) NSString* _Nonnull roundURL;
// skipped field BroadcastReport.EphID with unsupported type: gitlab.com/xx_network/primitives/id/ephemeral.Id

- (NSData* _Nullable)marshal:(NSError* _Nullable* _Nullable)error;
@end

/**
 * Channel is a bindings-level struct encapsulating the broadcast.Channel client
object.
 */
@interface BindingsChannel : NSObject <goSeqRefInterface, BindingsStopper> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
/**
 * Broadcast sends a given payload over the broadcast channel using symmetric
broadcast.

Returns:
 - []byte - the JSON marshalled bytes of the BroadcastReport object, which
   can be passed into Cmix.WaitForRoundResult to see if the broadcast
   succeeded.
 */
- (NSData* _Nullable)broadcast:(NSData* _Nullable)payload error:(NSError* _Nullable* _Nullable)error;
/**
 * BroadcastAsymmetric sends a given payload over the broadcast channel using
asymmetric broadcast. This mode of encryption requires a private key.

Returns:
 - []byte - the JSON marshalled bytes of the BroadcastReport object, which
   can be passed into WaitForRoundResult to see if the broadcast succeeded.
 */
- (NSData* _Nullable)broadcastAsymmetric:(NSData* _Nullable)payload pk:(NSData* _Nullable)pk error:(NSError* _Nullable* _Nullable)error;
/**
 * Get returns the result of calling json.Marshal on a ChannelDef based on the
underlying crypto broadcast.Channel.
 */
- (NSData* _Nullable)get:(NSError* _Nullable* _Nullable)error;
/**
 * Listen registers a BroadcastListener for a given method. This allows users to
handle incoming broadcast messages.

Parameters:
 - l - BroadcastListener object
 - method - int corresponding to broadcast.Method constant, 0 for symmetric
   or 1 for asymmetric
 */
- (BOOL)listen:(id<BindingsBroadcastListener> _Nullable)l method:(long)method error:(NSError* _Nullable* _Nullable)error;
/**
 * MaxAsymmetricPayloadSize returns the maximum possible payload size which can
be broadcast.
 */
- (long)maxAsymmetricPayloadSize;
/**
 * MaxPayloadSize returns the maximum possible payload size which can be
broadcast.
 */
- (long)maxPayloadSize;
/**
 * Stop stops the channel from listening for more messages.
 */
- (void)stop;
@end

/**
 * ChannelDef is the bindings representation of an elixxir/crypto
broadcast.Channel object.

Example JSON:
 {
   "Name": "My broadcast channel",
   "Description": "A broadcast channel for me to test things",
   "Salt": "gpUqW7N22sffMXsvPLE7BA==",
   "PubKey": "LS0tLS1CRUdJTiBSU0EgUFVCTElDIEtFWS0tLS0tCk1DZ0NJUUN2YkZVckJKRFpqT3Y0Y0MvUHZZdXNvQkFtUTFkb3Znb044aHRuUjA2T3F3SURBUUFCCi0tLS0tRU5EIFJTQSBQVUJMSUMgS0VZLS0tLS0="
 }
 */
@interface BindingsChannelDef : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSString* _Nonnull name;
@property (nonatomic) NSString* _Nonnull description;
@property (nonatomic) NSData* _Nullable salt;
@property (nonatomic) NSData* _Nullable pubKey;
@end

/**
 * Cmix wraps the xxdk.Cmix struct, implementing additional functions to support
the bindings Cmix interface.
 */
@interface BindingsCmix : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
/**
 * AddHealthCallback adds a callback that gets called whenever the network
health changes. Returns a registration ID that can be used to unregister.
 */
- (int64_t)addHealthCallback:(id<BindingsNetworkHealthCallback> _Nullable)nhc;
/**
 * Connect performs auth key negotiation with the given recipient and returns a
Connection object for the newly created partner.Manager.

This function is to be used sender-side and will block until the
partner.Manager is confirmed.

Parameters:
 - e2eId - ID of the E2E object in the e2e tracker
 - recipientContact - marshalled contact.Contact object
 - e2eParamsJSON - JSON marshalled byte of xxdk.E2EParams object
 */
- (BindingsConnection* _Nullable)connect:(long)e2eId recipientContact:(NSData* _Nullable)recipientContact e2eParamsJSON:(NSData* _Nullable)e2eParamsJSON error:(NSError* _Nullable* _Nullable)error;
- (BindingsAuthenticatedConnection* _Nullable)connectWithAuthentication:(long)e2eId recipientContact:(NSData* _Nullable)recipientContact e2eParamsJSON:(NSData* _Nullable)e2eParamsJSON error:(NSError* _Nullable* _Nullable)error;
/**
 * GetID returns the ID for this Cmix in the cmixTracker.
 */
- (long)getID;
/**
 * GetNodeRegistrationStatus returns the current state of node registration.

Returns:
 - []byte - A marshalled NodeRegistrationReport containing the number of
   nodes the user is registered with and the number of nodes present in the
   NDF.
 - An error if it cannot get the node registration status. The most likely
   cause is that the network is unhealthy.
 */
- (NSData* _Nullable)getNodeRegistrationStatus:(NSError* _Nullable* _Nullable)error;
/**
 * GetReceptionRegistrationValidationSignature returns the signature provided by
the xx network.
 */
- (NSData* _Nullable)getReceptionRegistrationValidationSignature;
/**
 * HasRunningProcessies checks if any background threads are running and returns
true if one or more are.

This is meant to be used when NetworkFollowerStatus returns xxdk.Stopping.
Due to the handling of comms on iOS, where the OS can block indefinitely, it
may not enter the stopped state appropriately. This can be used instead.
 */
- (BOOL)hasRunningProcessies;
/**
 * IsHealthy returns true if the network is read to be in a healthy state where
messages can be sent.
 */
- (BOOL)isHealthy;
/**
 * MakeLegacyReceptionIdentity generates the legacy identity for receiving
messages. As with all legacy calls, this should primarily be used
for the xx messenger team.
 */
- (NSData* _Nullable)makeLegacyReceptionIdentity:(NSError* _Nullable* _Nullable)error;
/**
 * MakeReceptionIdentity generates a new cryptographic identity for receiving
messages.
 */
- (NSData* _Nullable)makeReceptionIdentity:(NSError* _Nullable* _Nullable)error;
/**
 * NetworkFollowerStatus gets the state of the network follower. It returns a
status with the following values:
 Stopped  - 0
 Running  - 2000
 Stopping - 3000
 */
- (long)networkFollowerStatus;
/**
 * RegisterClientErrorCallback registers the callback to handle errors from the
long-running threads controlled by StartNetworkFollower and
StopNetworkFollower.
 */
- (void)registerClientErrorCallback:(id<BindingsClientError> _Nullable)clientError;
/**
 * RemoveHealthCallback removes a health callback using its registration ID.
 */
- (void)removeHealthCallback:(int64_t)funcID;
/**
 * StartNetworkFollower kicks off the tracking of the network. It starts long-
running network threads and returns an object for checking state and
stopping those threads.

Call this when returning from sleep and close when going back to sleep.

These threads may become a significant drain on battery when offline, ensure
they are stopped if there is no internet access.

Threads Started:
 - Network Follower (/network/follow.go)
   tracks the network events and hands them off to workers for handling.
 - Historical Round Retrieval (/network/rounds/historical.go)
   retrieves data about rounds that are too old to be stored by the client.
 - Message Retrieval Worker Group (/network/rounds/retrieve.go)
	  requests all messages in a given round from the gateway of the last nodes.
 - Message Handling Worker Group (/network/message/handle.go)
	  decrypts and partitions messages when signals via the Switchboard.
	- Health Tracker (/network/health),
	  via the network instance, tracks the state of the network.
 - Garbled Messages (/network/message/garbled.go)
	  can be signaled to check all recent messages that could be decoded. It
	  uses a message store on disk for persistence.
	- Critical Messages (/network/message/critical.go)
	  ensures all protocol layer mandatory messages are sent. It uses a message
	  store on disk for persistence.
	- KeyExchange Trigger (/keyExchange/trigger.go)
	  responds to sent rekeys and executes them.
 - KeyExchange Confirm (/keyExchange/confirm.go)
	  responds to confirmations of successful rekey operations.
 - Auth Callback (/auth/callback.go)
   handles both auth confirm and requests.
 */
- (BOOL)startNetworkFollower:(long)timeoutMS error:(NSError* _Nullable* _Nullable)error;
/**
 * StopNetworkFollower stops the network follower if it is running. It returns
an error if the follower is in the wrong state to stop or if it fails to stop
it.

If the network follower is running and this fails, the Cmix object will
most likely be in an unrecoverable state and need to be trashed.
 */
- (BOOL)stopNetworkFollower:(NSError* _Nullable* _Nullable)error;
/**
 * TrackServices will return via a callback the list of services the
backend keeps track of, which is formally referred to as a
[message.ServiceList]. This may be passed into other bindings call which
may need context on the available services for this client.

Parameters:
 - cb - A TrackServicesCallback, which will be passed the marshalled
   message.ServiceList.
 */
- (void)trackServices:(id<BindingsTrackServicesCallback> _Nullable)cb;
/**
 * WaitForNetwork will block until either the network is healthy or the passed
timeout is reached. It will return true if the network is healthy.
 */
- (BOOL)waitForNetwork:(long)timeoutMS;
/**
 * WaitForRoundResult allows the caller to get notified if the rounds a message
was sent in successfully completed. Under the hood, this uses an API that
uses the internal round data, network historical round lookup, and waiting on
network events to determine what has (or will) occur.

This function takes the marshaled send report to ensure a memory leak does
not occur as a result of both sides of the bindings holding a reference to
the same pointer.

Parameters:
 - roundList - JSON marshalled bytes of RoundsList or JSON of any send report
   that inherits a [bindings.RoundsList] object
 - mdc - callback that adheres to the MessageDeliveryCallback interface
 - timeoutMS - timeout when the callback will return if no state update
   occurs, in milliseconds
 */
- (BOOL)waitForRoundResult:(NSData* _Nullable)roundList mdc:(id<BindingsMessageDeliveryCallback> _Nullable)mdc timeoutMS:(long)timeoutMS error:(NSError* _Nullable* _Nullable)error;
@end

/**
 * Connection is the bindings' representation of a connect.Connection object
that can be tracked by ID.
 */
@interface BindingsConnection : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
/**
 * Close deletes this Connection's partner.Manager and releases resources.
 */
- (BOOL)close:(NSError* _Nullable* _Nullable)error;
/**
 * GetId returns the Connection ID.
 */
- (long)getId;
/**
 * GetPartner returns the partner.Manager for this Connection.
 */
- (NSData* _Nullable)getPartner;
/**
 * RegisterListener is used for E2E reception and allows for reading data sent
from the partner.Manager.
 */
- (BOOL)registerListener:(long)messageType newListener:(id<BindingsListener> _Nullable)newListener error:(NSError* _Nullable* _Nullable)error;
/**
 * SendE2E is a wrapper for sending specifically to the Connection's
partner.Manager.

Returns:
 - []byte - the JSON marshalled bytes of the E2ESendReport object, which can
   be passed into Cmix.WaitForRoundResult to see if the send succeeded.
 */
- (NSData* _Nullable)sendE2E:(long)mt payload:(NSData* _Nullable)payload error:(NSError* _Nullable* _Nullable)error;
@end

/**
 * DummyTraffic is the bindings-layer dummy (or "cover") traffic manager. T
The manager can be used to set and get the status of the thread responsible for
sending dummy messages.
 */
@interface BindingsDummyTraffic : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
/**
 * NewDummyTrafficManager creates a DummyTraffic manager and initialises the
dummy traffic sending thread. Note that the manager does not start sending
dummy traffic until true is passed into DummyTraffic.SetStatus. The time
duration between each sending operation and the amount of messages sent each
interval are randomly generated values with bounds defined by the given
parameters below.

Parameters:
 - cmixId - a Cmix object ID in the tracker.
 - maxNumMessages - the upper bound of the random number of messages sent
   each sending cycle.
 - avgSendDeltaMS - the average duration, in milliseconds, to wait between
   sends.
 - randomRangeMS - the upper bound of the interval between sending cycles, in
   milliseconds. Sends occur every avgSendDeltaMS +/- a random duration with
   an upper bound of randomRangeMS.
 */
- (nullable instancetype)initManager:(long)cmixId maxNumMessages:(long)maxNumMessages avgSendDeltaMS:(long)avgSendDeltaMS randomRangeMS:(long)randomRangeMS;
/**
 * GetStatus returns the current state of the DummyTraffic manager's sending
thread. Note that this function does not return the status set by the most
recent call to SetStatus. Instead, this call returns the current status of
the sending thread. This is due to the small delay that may occur between
calling SetStatus and the sending thread taking into effect that status
change.

Returns:
  - bool - Returns true if sending thread is sending dummy messages and false
    if sending thread is paused/stopped and is not sending dummy messages.
 */
- (BOOL)getStatus;
/**
 * SetStatus sets the state of the DummyTraffic manager's send thread by passing
in a boolean parameter. There may be a small delay in between this call and
the status of the sending thread to change accordingly. For example, passing
false into this call while the sending thread is currently sending messages
will not cancel nor halt the sending operation, but will pause the thread
once that operation has completed.

Parameters:
 - status - Input should be true if you want to send dummy messages and false
   if you want to pause dummy messages.

Returns:
 - error - if the DummyTraffic.SetStatus is called too frequently, causing
   the internal status channel to fill.
 */
- (BOOL)setStatus:(BOOL)status error:(NSError* _Nullable* _Nullable)error;
@end

/**
 * E2ESendReport is the bindings' representation of the return values of
SendE2E.

E2ESendReport Example JSON:
 {
		"Rounds": [ 1, 4, 9],
     "RoundURL":"https://dashboard.xx.network/rounds/25?xxmessenger=true",
		"MessageID": "iM34yCIr4Je8ZIzL9iAAG1UWAeDiHybxMTioMAaezvs=",
		"Timestamp": 1661532254302612000,
		"KeyResidue": "9q2/A69EAuFM1hFAT7Bzy5uGOQ4T6bPFF72h5PlgCWE="
 }
 */
@interface BindingsE2ESendReport : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
// skipped field E2ESendReport.RoundsList with unsupported type: gitlab.com/elixxir/client/bindings.RoundsList

@property (nonatomic) NSString* _Nonnull roundURL;
@property (nonatomic) NSData* _Nullable messageID;
@property (nonatomic) int64_t timestamp;
@property (nonatomic) NSData* _Nullable keyResidue;
- (NSData* _Nullable)marshal:(NSError* _Nullable* _Nullable)error;
@end

/**
 * E2e wraps the xxdk.E2e, implementing additional functions to support the
bindings E2e interface.
 */
@interface BindingsE2e : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
/**
 * AddPartnerCallback adds a new callback that overrides the generic auth
callback for the given partner ID.

Parameters:
 - partnerID - the marshalled bytes of the id.ID object.
 */
- (BOOL)addPartnerCallback:(NSData* _Nullable)partnerID cb:(id<BindingsAuthCallbacks> _Nullable)cb error:(NSError* _Nullable* _Nullable)error;
/**
 * AddService adds a service for all partners of the given tag, which will call
back on the given processor. These can be sent to using the tag fields in the
Params object.

Passing nil for the processor allows you to create a service that is never
called but will be visible by notifications. Processes added this way are
generally not end-to-end encrypted messages themselves, but other protocols
that piggyback on e2e relationships to start communication.
 */
- (BOOL)addService:(NSString* _Nullable)tag processor:(id<BindingsProcessor> _Nullable)processor error:(NSError* _Nullable* _Nullable)error;
/**
 * CallAllReceivedRequests will iterate through all pending contact requests and
replay them on the callbacks.
 */
- (void)callAllReceivedRequests;
/**
 * Confirm sends a confirmation for a received request. It can only be called
once. This both sends keying material to the other party and creates a
channel in the e2e handler, after which e2e messages can be sent to the
partner using E2e.SendE2E.

The round the request is initially sent on will be returned, but the request
will be listed as a critical message, so the underlying cMix client will auto
resend it in the event of failure.

A confirmation cannot be sent for a contact who has not sent a request or who
is already a partner. This can only be called once for a specific contact.
The confirmation sends as a critical message; if the round it sends on fails,
it will be auto resent by the cMix client.

If the confirmation must be resent, use ReplayConfirm.

Parameters:
 - partnerContact - the marshalled bytes of the contact.Contact object.

Returns:
 - int64 - ID of the round (convert to uint64)
 */
- (BOOL)confirm:(NSData* _Nullable)partnerContact ret0_:(int64_t* _Nullable)ret0_ error:(NSError* _Nullable* _Nullable)error;
/**
 * DeleteAllRequests clears all requests from auth storage.
 */
- (BOOL)deleteAllRequests:(NSError* _Nullable* _Nullable)error;
/**
 * DeletePartnerCallback deletes the callback that overrides the generic
auth callback for the given partner ID.

Parameters:
 - partnerID - the marshalled bytes of the id.ID object.
 */
- (BOOL)deletePartnerCallback:(NSData* _Nullable)partnerID error:(NSError* _Nullable* _Nullable)error;
/**
 * DeleteReceiveRequests clears all received requests from auth storage.
 */
- (BOOL)deleteReceiveRequests:(NSError* _Nullable* _Nullable)error;
/**
 * DeleteRequest deletes sent or received requests for a specific partner ID.

Parameters:
 - partnerID - the marshalled bytes of the id.ID object.
 */
- (BOOL)deleteRequest:(NSData* _Nullable)partnerID error:(NSError* _Nullable* _Nullable)error;
/**
 * DeleteSentRequests clears all sent requests from auth storage.
 */
- (BOOL)deleteSentRequests:(NSError* _Nullable* _Nullable)error;
/**
 * FirstPartitionSize returns the max partition payload size for the first
payload.
 */
- (long)firstPartitionSize;
/**
 * GetAllPartnerIDs returns a list of all partner IDs that the user has an E2E
relationship with.

Returns:
 - []byte - the marshalled bytes of []*id.ID.
 */
- (NSData* _Nullable)getAllPartnerIDs:(NSError* _Nullable* _Nullable)error;
/**
 * GetContact returns a marshalled contact.Contact object for the E2e
ReceptionIdentity.
 */
- (NSData* _Nullable)getContact;
/**
 * GetHistoricalDHPrivkey returns the user's marshalled historical DH private
key.

Returns:
 - []byte - the marshalled bytes of the cyclic.Int object.
 */
- (NSData* _Nullable)getHistoricalDHPrivkey:(NSError* _Nullable* _Nullable)error;
/**
 * GetHistoricalDHPubkey returns the user's marshalled historical DH public key.

Returns:
 - []byte - the marshalled bytes of the cyclic.Int object.
 */
- (NSData* _Nullable)getHistoricalDHPubkey:(NSError* _Nullable* _Nullable)error;
/**
 * GetID returns the ID for this E2e in the e2eTracker.
 */
- (long)getID;
/**
 * GetReceivedRequest returns a contact if there is a received request for it.

Parameters:
 - partnerID - the marshalled bytes of the id.ID object.

Returns:
 - []byte - the marshalled bytes of the contact.Contact object.
 */
- (NSData* _Nullable)getReceivedRequest:(NSData* _Nullable)partnerID error:(NSError* _Nullable* _Nullable)error;
/**
 * GetReceptionID returns the marshalled default IDs.

Returns:
 - []byte - the marshalled bytes of the id.ID object.
 */
- (NSData* _Nullable)getReceptionID;
/**
 * GetUdAddressFromNdf retrieve the User Discovery's network address fom the
NDF.
 */
- (NSString* _Nonnull)getUdAddressFromNdf;
/**
 * GetUdCertFromNdf retrieves the User Discovery's TLS certificate (in PEM
format) from the NDF.
 */
- (NSData* _Nullable)getUdCertFromNdf;
/**
 * GetUdContactFromNdf assembles the User Discovery's contact file from the data
within the NDF.

Returns
 - []byte - A byte marshalled contact.Contact.
 */
- (NSData* _Nullable)getUdContactFromNdf:(NSError* _Nullable* _Nullable)error;
/**
 * HasAuthenticatedChannel returns true if an authenticated channel with the
partner exists, otherwise returns false.

Parameters:
 - partnerId - the marshalled bytes of the id.ID object.
 */
- (BOOL)hasAuthenticatedChannel:(NSData* _Nullable)partnerId ret0_:(BOOL* _Nullable)ret0_ error:(NSError* _Nullable* _Nullable)error;
/**
 * PartitionSize returns the partition payload size for the given payload index.
The first payload is index 0.
 */
- (long)partitionSize:(long)payloadIndex;
/**
 * PayloadSize returns the max payload size for a partitionable E2E message.
 */
- (long)payloadSize;
/**
 * RegisterListener registers a new listener.

Parameters:
 - senderId - the user ID who sends messages to this user that
   this function will register a listener for.
 - messageType - message type from the sender you want to listen for.
 - newListener: A provider for a callback to hear a message.
   Do not pass nil to this.
 */
- (BOOL)registerListener:(NSData* _Nullable)senderID messageType:(long)messageType newListener:(id<BindingsListener> _Nullable)newListener error:(NSError* _Nullable* _Nullable)error;
/**
 * RemoveService removes all services for the given tag.
 */
- (BOOL)removeService:(NSString* _Nullable)tag error:(NSError* _Nullable* _Nullable)error;
/**
 * ReplayConfirm resends a confirmation to the partner. It will fail to send if
the send relationship with the partner has already ratcheted.

The confirmation sends as a critical message; if the round it sends on fails,
it will be auto resent by the cMix client.

This will not be useful if either side has ratcheted.

Parameters:
 - partnerID - the marshalled bytes of the id.ID object.

Returns:
 - int64 - ID of the round (convert to uint64)
 */
- (BOOL)replayConfirm:(NSData* _Nullable)partnerID ret0_:(int64_t* _Nullable)ret0_ error:(NSError* _Nullable* _Nullable)error;
/**
 * Request sends a contact request from the user identity in the imported E2e
structure to the passed contact, as well as the passed facts (it will error
if they are too long).

The other party must accept the request by calling Confirm to be able to send
messages using E2e.SendE2E. When the other party does so, the "confirm"
callback will get called.

The round the request is initially sent on will be returned, but the request
will be listed as a critical message, so the underlying cMix client will auto
resend it in the event of failure.

A request cannot be sent for a contact who has already received a request or
who is already a partner.

The request sends as a critical message, if the round it sends on fails, it
will be auto resent by the cMix client.

Parameters:
 - partnerContact - the marshalled bytes of the contact.Contact object.
 - factsListJson - the JSON marshalled bytes of [fact.FactList].

Returns:
 - int64 - ID of the round (convert to uint64)
 */
- (BOOL)request:(NSData* _Nullable)partnerContact factsListJson:(NSData* _Nullable)factsListJson ret0_:(int64_t* _Nullable)ret0_ error:(NSError* _Nullable* _Nullable)error;
/**
 * Reset sends a contact reset request from the user identity in the imported
e2e structure to the passed contact, as well as the passed facts (it will
error if they are too long).

This deletes all traces of the relationship with the partner from e2e and
create a new relationship from scratch.

The round the reset is initially sent on will be returned, but the request
will be listed as a critical message, so the underlying cMix client will auto
resend it in the event of failure.

A request cannot be sent for a contact who has already received a request or
who is already a partner.

Parameters:
 - partnerContact - the marshalled bytes of the contact.Contact object.

Returns:
 - int64 - ID of the round (convert to uint64)
 */
- (BOOL)reset:(NSData* _Nullable)partnerContact ret0_:(int64_t* _Nullable)ret0_ error:(NSError* _Nullable* _Nullable)error;
/**
 * SecondPartitionSize returns the max partition payload size for all payloads
after the first payload.
 */
- (long)secondPartitionSize;
/**
 * SendE2E send a message containing the payload to the recipient of the passed
message type, per the given parameters--encrypted with end-to-end encryption.

Parameters:
 - recipientId - the marshalled bytes of the id.ID object.
 - e2eParams - the marshalled bytes of the e2e.Params object.

Returns:
 - []byte - the JSON marshalled bytes of the E2ESendReport object, which can
   be passed into Cmix.WaitForRoundResult to see if the send succeeded.
 */
- (NSData* _Nullable)sendE2E:(long)messageType recipientId:(NSData* _Nullable)recipientId payload:(NSData* _Nullable)payload e2eParamsJSON:(NSData* _Nullable)e2eParamsJSON error:(NSError* _Nullable* _Nullable)error;
/**
 * VerifyOwnership checks if the received ownership proof is valid.

Parameters:
 - receivedContact, verifiedContact - the marshalled bytes of the
     contact.Contact object.
 - e2eId - ID of the e2e handler
 */
- (BOOL)verifyOwnership:(NSData* _Nullable)receivedContact verifiedContact:(NSData* _Nullable)verifiedContact e2eId:(long)e2eId ret0_:(BOOL* _Nullable)ret0_ error:(NSError* _Nullable* _Nullable)error;
@end

/**
 * EventReport is a public struct which represents the contents of an event
report.

Example JSON:
 {
  "Priority":1,
  "Category":"Test Events",
  "EventType":"Ping",
  "Details":"This is an example of an event report"
 }
 */
@interface BindingsEventReport : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) long priority;
@property (nonatomic) NSString* _Nonnull category;
@property (nonatomic) NSString* _Nonnull eventType;
@property (nonatomic) NSString* _Nonnull details;
@end

/**
 * FilePartTracker contains the fileTransfer.FilePartTracker.
 */
@interface BindingsFilePartTracker : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
/**
 * GetNumParts returns the total number of file parts in the transfer.
 */
- (long)getNumParts;
/**
 * GetPartStatus returns the status of the file part with the given part number.

The possible values for the status are:
 - 0 < Part does not exist
 - 0 = unsent
 - 1 = arrived (sender has sent a part, and it has arrived)
 - 2 = received (receiver has received a part)
 */
- (long)getPartStatus:(long)partNum;
@end

/**
 * FileSend is a public struct that contains the file contents and its name,
type, and preview.
 {
  "Name":"testfile.txt",
  "Type":"text file",
  "Preview":"aXQncyBtZSBhIHByZXZpZXc=",
  "Contents":"VGhpcyBpcyB0aGUgZnVsbCBjb250ZW50cyBvZiB0aGUgZmlsZSBpbiBieXRlcw=="
 }
 */
@interface BindingsFileSend : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSString* _Nonnull name;
@property (nonatomic) NSString* _Nonnull type;
@property (nonatomic) NSData* _Nullable preview;
@property (nonatomic) NSData* _Nullable contents;
@end

/**
 * FileTransfer object is a bindings-layer struct which wraps a
fileTransfer.FileTransfer interface.
 */
@interface BindingsFileTransfer : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
/**
 * CloseSend deletes a file from the internal storage once a transfer has
completed or reached the retry limit. Returns an error if the transfer has
not run out of retries.

This function should be called once a transfer completes or errors out (as
reported by the progress callback).

Parameters:
 - tidBytes - file transfer ID
 */
- (BOOL)closeSend:(NSData* _Nullable)tidBytes error:(NSError* _Nullable* _Nullable)error;
/**
 * MaxFileNameLen returns the max number of bytes allowed for a file name.
 */
- (long)maxFileNameLen;
/**
 * MaxFileSize returns the max number of bytes allowed for a file.
 */
- (long)maxFileSize;
/**
 * MaxFileTypeLen returns the max number of bytes allowed for a file type.
 */
- (long)maxFileTypeLen;
/**
 * MaxPreviewSize returns the max number of bytes allowed for a file preview.
 */
- (long)maxPreviewSize;
/**
 * Receive returns the full file on the completion of the transfer. It deletes
internal references to the data and unregisters any attached progress
callbacks. Returns an error if the transfer is not complete, the full file
cannot be verified, or if the transfer cannot be found.

Receive can only be called once the progress callback returns that the
file transfer is complete.

Parameters:
 - tidBytes - file transfer ID
 */
- (NSData* _Nullable)receive:(NSData* _Nullable)tidBytes error:(NSError* _Nullable* _Nullable)error;
/**
 * RegisterReceivedProgressCallback allows for the registration of a callback to
track the progress of an individual received file transfer.

This should be done when a new transfer is received on the ReceiveCallback.

Parameters:
 - tidBytes - file transfer ID
 - callback - callback that reports file reception progress
 - period - duration to wait between progress callbacks triggering
 */
- (BOOL)registerReceivedProgressCallback:(NSData* _Nullable)tidBytes callback:(id<BindingsFileTransferReceiveProgressCallback> _Nullable)callback period:(NSString* _Nullable)period error:(NSError* _Nullable* _Nullable)error;
/**
 * RegisterSentProgressCallback allows for the registration of a callback to
track the progress of an individual sent file transfer.

SentProgressCallback is auto registered on Send; this function should be
called when resuming clients or registering extra callbacks.

Parameters:
 - tidBytes - file transfer ID
 - callback - callback that reports file reception progress
 - period - duration to wait between progress callbacks triggering
 */
- (BOOL)registerSentProgressCallback:(NSData* _Nullable)tidBytes callback:(id<BindingsFileTransferSentProgressCallback> _Nullable)callback period:(NSString* _Nullable)period error:(NSError* _Nullable* _Nullable)error;
/**
 * Send is the bindings-level function for sending a file.

Parameters:
 - payload - JSON marshalled FileSend
 - recipientID - marshalled recipient id.ID
 - retry - number of retries allowed
 - callback - callback that reports file sending progress
 - period - duration to wait between progress callbacks triggering

Returns:
 - []byte - unique file transfer ID
 */
- (NSData* _Nullable)send:(NSData* _Nullable)payload recipientID:(NSData* _Nullable)recipientID retry:(float)retry callback:(id<BindingsFileTransferSentProgressCallback> _Nullable)callback period:(NSString* _Nullable)period error:(NSError* _Nullable* _Nullable)error;
@end

/**
 * Group structure contains the identifying and membership information of a
group chat.
 */
@interface BindingsGroup : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
/**
 * GetCreatedMS returns the time the group was created in milliseconds. This is
also the time the group requests were sent.
 */
- (int64_t)getCreatedMS;
/**
 * GetCreatedNano returns the time the group was created in nanoseconds. This is
also the time the group requests were sent.
 */
- (int64_t)getCreatedNano;
/**
 * GetID return the 33-byte unique group ID. This represents the id.ID object.
 */
- (NSData* _Nullable)getID;
/**
 * GetInitMessage returns initial message sent with the group request.
 */
- (NSData* _Nullable)getInitMessage;
/**
 * GetMembership retrieves a list of group members. The list is in order;
the first contact is the leader/creator of the group.
All subsequent members are ordered by their ID.

Returns:
 - []byte - JSON marshalled [group.Membership], which is an array of
   [group.Member].

Example JSON [group.Membership] return:
 [
   {
     "ID": "U4x/lrFkvxuXu59LtHLon1sUhPJSCcnZND6SugndnVID",
     "DhKey": {
       "Value": 3534334367214237261,
       "Fingerprint": 16801541511233098363
     }
   },
   {
     "ID": "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD",
     "DhKey": {
       "Value": 7497468244883513247,
       "Fingerprint": 16801541511233098363
     }
   }
 ]
 */
- (NSData* _Nullable)getMembership:(NSError* _Nullable* _Nullable)error;
/**
 * GetName returns the name set by the user for the group.
 */
- (NSData* _Nullable)getName;
/**
 * GetTrackedID returns the tracked ID of the Group object. This is used by the
backend tracker.
 */
- (long)getTrackedID;
/**
 * Serialize serializes the Group.
 */
- (NSData* _Nullable)serialize;
@end

/**
 * GroupChat is a binding-layer group chat manager.
 */
@interface BindingsGroupChat : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
/**
 * NewGroupChat creates a bindings-layer group chat manager.

Parameters:
 - e2eID - e2e object ID in the tracker.
 - requestFunc - a callback to handle group chat requests.
 - processor - the group chat message processor.
 */
- (nullable instancetype)init:(long)e2eID requestFunc:(id<BindingsGroupRequest> _Nullable)requestFunc processor:(id<BindingsGroupChatProcessor> _Nullable)processor;
/**
 * GetGroup returns the group with the group ID. If no group exists, then the
error "failed to find group" is returned.

Parameters:
 - groupId - The byte data representing a group ID (a byte marshalled id.ID).
   This can be pulled from a marshalled GroupReport.
Returns:
 - Group - The bindings-layer representation of a group.
 */
- (BindingsGroup* _Nullable)getGroup:(NSData* _Nullable)groupId error:(NSError* _Nullable* _Nullable)error;
/**
 * GetGroups returns a list of group IDs that the user is a member of.

Returns:
 - []byte - a JSON marshalled []*id.ID representing all group ID's.
 */
- (NSData* _Nullable)getGroups:(NSError* _Nullable* _Nullable)error;
/**
 * JoinGroup allows a user to join a group when a request is received.
If an error is returned, handle it properly first; you may then retry later
with the same trackedGroupId.

Parameters:
 - trackedGroupId - the ID to retrieve the Group object within the backend's
   tracking system. This is received by GroupRequest.Callback.
 */
- (BOOL)joinGroup:(long)trackedGroupId error:(NSError* _Nullable* _Nullable)error;
/**
 * LeaveGroup deletes a group so a user no longer has access.

Parameters:
 - groupId - the byte data representing a group ID.
   This can be pulled from a marshalled GroupReport.
 */
- (BOOL)leaveGroup:(NSData* _Nullable)groupId error:(NSError* _Nullable* _Nullable)error;
/**
 * MakeGroup creates a new Group and sends a group request to all members in the
group.

Parameters:
 - membershipBytes - the JSON marshalled list of []*id.ID; it contains the
   IDs of members the user wants to add to the group.
 - message - the initial message sent to all members in the group. This is an
   optional parameter and may be nil.
 - name - the name of the group decided by the creator. This is an optional
   parameter and may be nil. If nil the group will be assigned the default
   name.

Returns:
 - []byte - the JSON marshalled bytes of the GroupReport object, which can be
   passed into Cmix.WaitForRoundResult to see if the group request message
   send succeeded.
 */
- (NSData* _Nullable)makeGroup:(NSData* _Nullable)membershipBytes message:(NSData* _Nullable)message name:(NSData* _Nullable)name error:(NSError* _Nullable* _Nullable)error;
/**
 * NumGroups returns the number of groups the user is a part of.
 */
- (long)numGroups;
/**
 * ResendRequest resends a group request to all members in the group.

Parameters:
 - groupId - a byte representation of a group's ID.
   This can be found in the report returned by GroupChat.MakeGroup.

Returns:
 - []byte - the JSON marshalled bytes of the GroupReport object, which can be
   passed into WaitForRoundResult to see if the group request message send
   succeeded.
 */
- (NSData* _Nullable)resendRequest:(NSData* _Nullable)groupId error:(NSError* _Nullable* _Nullable)error;
/**
 * Send is the bindings-level function for sending to a group.

Parameters:
 - groupId - the byte data representing a group ID. This can be pulled from
   marshalled GroupReport.
 - message - the message that the user wishes to send to the group.
 - tag - the tag associated with the message. This tag may be empty.

Returns:
 - []byte - the JSON marshalled bytes of the GroupSendReport object, which
   can be passed into Cmix.WaitForRoundResult to see if the group message
   send succeeded.
 */
- (NSData* _Nullable)send:(NSData* _Nullable)groupId message:(NSData* _Nullable)message tag:(NSString* _Nullable)tag error:(NSError* _Nullable* _Nullable)error;
@end

/**
 * GroupChatMessage is the bindings layer representation of the
[groupChat.MessageReceive].

GroupChatMessage Example JSON:
 {
   "GroupId": "AAAAAAAJlasAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAE",
   "SenderId": "AAAAAAAAB8gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD",
   "MessageId": "Zm9ydHkgZml2ZQAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=",
   "Payload": "Zm9ydHkgZml2ZQ==",
   "Timestamp": 1663009269474079000
 }
 */
@interface BindingsGroupChatMessage : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
/**
 * GroupId is the ID of the group that this message was sent on.
 */
@property (nonatomic) NSData* _Nullable groupId;
/**
 * SenderId is the ID of the sender of this message.
 */
@property (nonatomic) NSData* _Nullable senderId;
/**
 * MessageId is the ID of this group message.
 */
@property (nonatomic) NSData* _Nullable messageId;
/**
 * Payload is the content of the message.
 */
@property (nonatomic) NSData* _Nullable payload;
/**
 * Timestamp is the time this message was sent on.
 */
@property (nonatomic) int64_t timestamp;
@end

/**
 * GroupReport is returned when creating a new group and contains the ID of
the group, a list of rounds that the group requests were sent on, and the
status of the send operation.

Example GroupReport JSON:
		{
			"Id": "AAAAAAAAAM0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAE",
			"Rounds": [25, 64],
			"RoundURL": "https://dashboard.xx.network/rounds/25?xxmessenger=true",
			"Status": 1
		}
 */
@interface BindingsGroupReport : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSData* _Nullable id_;
// skipped field GroupReport.RoundsList with unsupported type: gitlab.com/elixxir/client/bindings.RoundsList

@property (nonatomic) NSString* _Nonnull roundURL;
@property (nonatomic) long status;
- (NSData* _Nullable)marshal:(NSError* _Nullable* _Nullable)error;
@end

/**
 * GroupSendReport is returned when sending a group message. It contains the
round ID sent on and the timestamp of the send operation.

Example GroupSendReport JSON:
     {
 	"Rounds": [25,	64],
 	"RoundURL": "https://dashboard.xx.network/rounds/25?xxmessenger=true",
 	"Timestamp": 1662577352813112000,
 	"MessageID": "69ug6FA50UT2q6MWH3hne9PkHQ+H9DnEDsBhc0m0Aww="
	    }
 */
@interface BindingsGroupSendReport : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
// skipped field GroupSendReport.RoundsList with unsupported type: gitlab.com/elixxir/client/bindings.RoundsList

@property (nonatomic) NSString* _Nonnull roundURL;
@property (nonatomic) int64_t timestamp;
@property (nonatomic) NSData* _Nullable messageID;
- (NSData* _Nullable)marshal:(NSError* _Nullable* _Nullable)error;
@end

/**
 * Message is the bindings' representation of a receive.Message.

JSON example:
 {
  "MessageType":1,
  "ID":"EB/70R5HYEw5htZ4Hg9ondrn3+cAc/lH2G0mjQMja3w=",
  "Payload":"7TzZKgNphT5UooNM7mDSwtVcIs8AIu4vMKm4ld6GSR8YX5GrHirixUBAejmsgdroRJyo06TkIVef7UM9FN8YfQ==",
  "Sender":"emV6aW1hAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD",
  "RecipientID":"amFrZXh4MzYwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD",
  "EphemeralID":17,"Timestamp":1653580439357351000,
  "Encrypted":false,
  "RoundId":19
 }
 */
@interface BindingsMessage : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) long messageType;
@property (nonatomic) NSData* _Nullable id_;
@property (nonatomic) NSData* _Nullable payload;
@property (nonatomic) NSData* _Nullable sender;
@property (nonatomic) NSData* _Nullable recipientID;
@property (nonatomic) int64_t ephemeralID;
@property (nonatomic) int64_t timestamp;
@property (nonatomic) BOOL encrypted;
@property (nonatomic) long roundId;
@property (nonatomic) NSString* _Nonnull roundURL;
@end

/**
 * NodeRegistrationReport is the report structure which
Cmix.GetNodeRegistrationStatus returns JSON marshalled.
 */
@interface BindingsNodeRegistrationReport : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) long numberOfNodesRegistered;
@property (nonatomic) long numberOfNodes;
@end

/**
 * NotificationReport is the bindings' representation for notifications for
this user.

Example NotificationReport JSON:
 {
   "ForMe": true,
   "Type": "e2e",
   "Source": "dGVzdGVyMTIzAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
 }

Given the Type, the Source value will have specific contextual meanings.
Below is a table that will define the contextual meaning of the Source field
given all possible Type fields.

  TYPE     |     SOURCE         |    DESCRIPTION
 ----------+--------------------+--------------------------------------------------------
 "default" |  recipient user ID |  A message with no association.
 "request" |  sender user ID    |  A channel request has been received, from Source.
 "reset"   |  sender user ID    |  A channel reset has been received.
 "confirm" |  sender user ID    |  A channel request has been accepted.
 "silent"  |  sender user ID    |  A message where the user should not be notified.
 "e2e"     |  sender user ID    |  A reception of an E2E message.
 "group"   |  group ID          |  A reception of a group chat message.
 "endFT"   |  sender user ID    |  The last message sent confirming end of file transfer.
 "groupRQ" |  sender user ID    |  A request from Source to join a group chat.
 */
@interface BindingsNotificationReport : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
/**
 * ForMe determines whether this value is for the user. If it is
false, this report may be ignored.
 */
@property (nonatomic) BOOL forMe;
/**
 * Type is the type of notification. The list can be seen
 */
@property (nonatomic) NSString* _Nonnull type;
/**
 * Source is the source of the notification.
 */
@property (nonatomic) NSData* _Nullable source;
@end

/**
 * Progress is a public struct that represents the progress of an in-progress
file transfer.

Example JSON:
 {
  "Completed":false,
  "Transmitted":128,
  "Total":2048,
  "Err":null
 }
 */
@interface BindingsProgress : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) BOOL completed;
@property (nonatomic) long transmitted;
@property (nonatomic) long total;
@property (nonatomic) NSError* _Nullable err;
@end

/**
 * ReceivedFile is a public struct that contains the metadata of a new file
transfer.

Example JSON:
 {
  "TransferID":"B4Z9cwU18beRoGbk5xBjbcd5Ryi9ZUFA2UBvi8FOHWo=",
  "SenderID":"emV6aW1hAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD",
  "Preview":"aXQncyBtZSBhIHByZXZpZXc=",
  "Name":"testfile.txt",
  "Type":"text file",
  "Size":2048
 }
 */
@interface BindingsReceivedFile : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSData* _Nullable transferID;
@property (nonatomic) NSData* _Nullable senderID;
@property (nonatomic) NSData* _Nullable preview;
@property (nonatomic) NSString* _Nonnull name;
@property (nonatomic) NSString* _Nonnull type;
@property (nonatomic) long size;
@end

/**
 * ReceptionIdentity struct.

JSON example:
 {
  "ID":"emV6aW1hAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD",
  "RSAPrivatePem":"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",
  "Salt":"4kk02v0NIcGtlobZ/xkxqWz8uH/ams/gjvQm14QT0dI=",
  "DHKeyPrivate":"eyJWYWx1ZSI6NDU2MDgzOTEzMjA0OTIyODA5Njg2MDI3MzQ0MzM3OTA0MzAyODYwMjM2NDk2NDM5NDI4NTcxMTMwNDMzOTQwMzgyMTIyMjY4OTQzNTMyMjIyMzc1MTkzNTEzMjU4MjA4MDA0NTczMDY4MjEwNzg2NDI5NjA1MjA0OTA3MjI2ODI5OTc3NTczMDkxODY0NTY3NDExMDExNjQxNCwiRmluZ2VycHJpbnQiOjE2ODAxNTQxNTExMjMzMDk4MzYzfQ=="
  "E2eGrp": "eyJnZW4iOiIyIiwicHJpbWUiOiJlMmVlOTgzZDAzMWRjMWRiNmYxYTdhNjdkZjBlOWE4ZTU1NjFkYjhlOGQ0OTQxMzM5NGMwNDliN2E4YWNjZWRjMjk4NzA4ZjEyMTk1MWQ5Y2Y5MjBlYzVkMTQ2NzI3YWE0YWU1MzViMDkyMmM2ODhiNTViM2RkMmFlZGY2YzAxYzk0NzY0ZGFiOTM3OTM1YWE4M2JlMzZlNjc3NjA3MTNhYjQ0YTYzMzdjMjBlNzg2MTU3NWU3NDVkMzFmOGI5ZTlhZDg0MTIxMThjNjJhM2UyZTI5ZGY0NmIwODY0ZDBjOTUxYzM5NGE1Y2JiZGM2YWRjNzE4ZGQyYTNlMDQxMDIzZGJiNWFiMjNlYmI0NzQyZGU5YzE2ODdiNWIzNGZhNDhjMzUyMTYzMmM0YTUzMGU4ZmZiMWJjNTFkYWRkZjQ1M2IwYjI3MTdjMmJjNjY2OWVkNzZiNGJkZDVjOWZmNTU4ZTg4ZjI2ZTU3ODUzMDJiZWRiY2EyM2VhYzVhY2U5MjA5NmVlOGE2MDY0MmZiNjFlOGYzZDI0OTkwYjhjYjEyZWU0NDhlZWY3OGUxODRjNzI0MmRkMTYxYzc3MzhmMzJiZjI5YTg0MTY5ODk3ODgyNWI0MTExYjRiYzNlMWUxOTg0NTUwOTU5NTgzMzNkNzc2ZDhiMmJlZWVkM2ExYTFhMjIxYTZlMzdlNjY0YTY0YjgzOTgxYzQ2ZmZkZGMxYTQ1ZTNkNTIxMWFhZjhiZmJjMDcyNzY4YzRmNTBkN2Q3ODAzZDJkNGYyNzhkZTgwMTRhNDczMjM2MzFkN2UwNjRkZTgxYzBjNmJmYTQzZWYwZTY5OTg4NjBmMTM5MGI1ZDNmZWFjYWYxNjk2MDE1Y2I3OWMzZjljMmQ5M2Q5NjExMjBjZDBlNWYxMmNiYjY4N2VhYjA0NTI0MWY5Njc4OWMzOGU4OWQ3OTYxMzhlNjMxOWJlNjJlMzVkODdiMTA0OGNhMjhiZTM4OWI1NzVlOTk0ZGNhNzU1NDcxNTg0YTA5ZWM3MjM3NDJkYzM1ODczODQ3YWVmNDlmNjZlNDM4NzMifQ=="
}
 */
@interface BindingsReceptionIdentity : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSData* _Nullable id_;
@property (nonatomic) NSData* _Nullable rsaPrivatePem;
@property (nonatomic) NSData* _Nullable salt;
@property (nonatomic) NSData* _Nullable dhKeyPrivate;
@property (nonatomic) NSData* _Nullable e2eGrp;
@end

/**
 * RestlikeMessage is the bindings' representation of a restlike.Message

JSON example:
 {
  "Version":1,
  "Headers":"Y29udGVudHM6YXBwbGljYXRpb24vanNvbg==",
  "Content":"VGhpcyBpcyBhIHJlc3RsaWtlIG1lc3NhZ2U=",
  "Method":2,
  "URI":"xx://CmixRestlike/rest",
  "Error":""
 }
 */
@interface BindingsRestlikeMessage : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
// skipped field RestlikeMessage.Version with unsupported type: uint32

@property (nonatomic) NSData* _Nullable headers;
@property (nonatomic) NSData* _Nullable content;
@property (nonatomic) long method;
@property (nonatomic) NSString* _Nonnull uri;
@property (nonatomic) NSString* _Nonnull error;
@end

/**
 * RoundsList contains a list of round IDs.

JSON Example:
 [1001,1003,1006]
 */
@interface BindingsRoundsList : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
// skipped field RoundsList.Rounds with unsupported type: []uint64

/**
 * Marshal JSON marshals the RoundsList.
 */
- (NSData* _Nullable)marshal:(NSError* _Nullable* _Nullable)error;
@end

/**
 * SingleUseCallbackReport is the bindings-layer struct used to represent
single -use messages received by a callback passed into single.Listen.

SingleUseCallbackReport JSON example:
   {
     "Rounds":[1,5,9],
     "RoundURL": "https://dashboard.xx.network/rounds/25?xxmessenger=true",
     "Payload":"rSuPD35ELWwm5KTR9ViKIz/r1YGRgXIl5792SF8o8piZzN6sT4Liq4rUU/nfOPvQEjbfWNh/NYxdJ72VctDnWw==",
     "Partner":"emV6aW1hAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD",
     "EphID":1655533,
     "ReceptionID":"emV6aW1hAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD"}
   }
 */
@interface BindingsSingleUseCallbackReport : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
// skipped field SingleUseCallbackReport.RoundsList with unsupported type: gitlab.com/elixxir/client/bindings.RoundsList

@property (nonatomic) NSString* _Nonnull roundURL;
@property (nonatomic) NSData* _Nullable payload;
// skipped field SingleUseCallbackReport.Partner with unsupported type: *gitlab.com/xx_network/primitives/id.ID

@property (nonatomic) int64_t ephID;
// skipped field SingleUseCallbackReport.ReceptionID with unsupported type: *gitlab.com/xx_network/primitives/id.ID

- (NSData* _Nullable)marshal:(NSError* _Nullable* _Nullable)error;
@end

/**
 * SingleUseResponseReport is the bindings-layer struct used to represent
information passed to the single.Response callback interface in response to
single.TransmitRequest.

SingleUseResponseReport JSON example:
 {
  "Rounds":[1,5,9],
  "RoundURL": "https://dashboard.xx.network/rounds/25?xxmessenger=true",
  "Payload":"rSuPD35ELWwm5KTR9ViKIz/r1YGRgXIl5792SF8o8piZzN6sT4Liq4rUU/nfOPvQEjbfWNh/NYxdJ72VctDnWw==",
  "EphID":1655533,
  "ReceptionID":"emV6aW1hAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD"},
  "Err":"",
 }
 */
@interface BindingsSingleUseResponseReport : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
// skipped field SingleUseResponseReport.RoundsList with unsupported type: gitlab.com/elixxir/client/bindings.RoundsList

@property (nonatomic) NSString* _Nonnull roundURL;
@property (nonatomic) NSData* _Nullable payload;
// skipped field SingleUseResponseReport.ReceptionID with unsupported type: *gitlab.com/xx_network/primitives/id.ID

@property (nonatomic) int64_t ephID;
@property (nonatomic) NSError* _Nullable err;
- (NSData* _Nullable)marshal:(NSError* _Nullable* _Nullable)error;
@end

/**
 * SingleUseSendReport is the bindings-layer struct used to represent
information returned by single.TransmitRequest.

SingleUseSendReport JSON example:
 {
  "Rounds":[1,5,9],
  "RoundURL": "https://dashboard.xx.network/rounds/25?xxmessenger=true",
  "EphID":1655533,
  "ReceptionID":"emV6aW1hAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD"}
 }
 */
@interface BindingsSingleUseSendReport : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
// skipped field SingleUseSendReport.RoundsList with unsupported type: gitlab.com/elixxir/client/bindings.RoundsList

@property (nonatomic) NSString* _Nonnull roundURL;
// skipped field SingleUseSendReport.ReceptionID with unsupported type: *gitlab.com/xx_network/primitives/id.ID

@property (nonatomic) int64_t ephID;
- (NSData* _Nullable)marshal:(NSError* _Nullable* _Nullable)error;
@end

/**
 * UserDiscovery is a bindings-layer struct that wraps an ud.Manager interface.
 */
@interface BindingsUserDiscovery : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
/**
 * ConfirmFact confirms a fact first registered via SendRegisterFact. The
confirmation ID comes from SendRegisterFact while the code will come over the
associated communications system.
 */
- (BOOL)confirmFact:(NSString* _Nullable)confirmationID code:(NSString* _Nullable)code error:(NSError* _Nullable* _Nullable)error;
/**
 * GetContact returns the marshalled bytes of the contact.Contact for UD as
retrieved from the NDF.
 */
- (NSData* _Nullable)getContact:(NSError* _Nullable* _Nullable)error;
/**
 * GetFacts returns a JSON marshalled list of [fact.Fact] objects that exist
within the Store's registeredFacts map.
 */
- (NSData* _Nullable)getFacts;
/**
 * GetID returns the udTracker ID for the UserDiscovery object.
 */
- (long)getID;
/**
 * PermanentDeleteAccount removes the username associated with this user from
the UD service. This will only take a username type fact, and the fact must
be associated with this user.

Parameters:
 - factJson - a JSON marshalled [fact.Fact]
 */
- (BOOL)permanentDeleteAccount:(NSData* _Nullable)factJson error:(NSError* _Nullable* _Nullable)error;
/**
 * RemoveFact removes a previously confirmed fact. This will fail if the fact
passed in is not UD service does not associate this fact with this user.

Parameters:
 - factJson - a JSON marshalled [fact.Fact]
 */
- (BOOL)removeFact:(NSData* _Nullable)factJson error:(NSError* _Nullable* _Nullable)error;
/**
 * SendRegisterFact adds a fact for the user to user discovery. Will only
succeed if the user is already registered and the system does not have the
fact currently registered for any user.

This does not complete the fact registration process, it returns a
confirmation ID instead. Over the communications system the fact is
associated with, a code will be sent. This confirmation ID needs to be called
along with the code to finalize the fact.

Parameters:
 - factJson - a JSON marshalled [fact.Fact]
 */
- (NSString* _Nonnull)sendRegisterFact:(NSData* _Nullable)factJson error:(NSError* _Nullable* _Nullable)error;
@end

/**
 * Error codes
 */
FOUNDATION_EXPORT NSString* _Nonnull const BindingsUnrecognizedCode;
/**
 * Error codes
 */
FOUNDATION_EXPORT NSString* _Nonnull const BindingsUnrecognizedMessage;

/**
 * AsyncRequestRestLike sends an asynchronous restlike request to a given
contact.

Parameters:
 - e2eID - ID of the e2e object in the tracker
 - recipient - marshalled contact.Contact object
 - request - JSON marshalled RestlikeMessage
 - paramsJSON - JSON marshalled single.RequestParams
 - cb - RestlikeCallback callback

Returns an error, and the RestlikeCallback will be called with the results
of JSON marshalling the response when received.
 */
FOUNDATION_EXPORT BOOL BindingsAsyncRequestRestLike(long e2eID, NSData* _Nullable recipient, NSData* _Nullable request, NSData* _Nullable paramsJSON, id<BindingsRestlikeCallback> _Nullable cb, NSError* _Nullable* _Nullable error);

/**
 * CreateUserFriendlyErrorMessage will convert the passed in error string to an
error string that is user-friendly if a substring match is found to a
common error. Common errors is a map that can be updated using
UpdateCommonErrors. If the error is not common, some simple parsing is done
on the error message to make it more user-accessible, removing backend
specific jargon.

Parameters:
  - errStr - an error returned from the backend.

Returns
 - A user-friendly error message. This should be devoid of technical speak
   but still be meaningful for front-end or back-end teams.
 */
FOUNDATION_EXPORT NSString* _Nonnull BindingsCreateUserFriendlyErrorMessage(NSString* _Nullable errStr);

/**
 * DownloadAndVerifySignedNdfWithUrl retrieves the NDF from a specified URL.
The NDF is processed into a protobuf containing a signature that is verified
using the cert string passed in. The NDF is returned as marshaled byte data
that may be used to start a client.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsDownloadAndVerifySignedNdfWithUrl(NSString* _Nullable url, NSString* _Nullable cert, NSError* _Nullable* _Nullable error);

/**
 * EnableGrpcLogs sets GRPC trace logging.
 */
FOUNDATION_EXPORT void BindingsEnableGrpcLogs(id<BindingsLogWriter> _Nullable writer);

/**
 * GenerateSecret creates a secret password using a system-based pseudorandom
number generator.

Parameters:
 - numBytes - The size of secret. It should be set to 32, but can be set
  higher in certain cases.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsGenerateSecret(long numBytes);

/**
 * GetDefaultCMixParams returns a JSON serialized object with all of the cMix
parameters and their default values. Call this function and modify the JSON
to change cMix settings.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsGetDefaultCMixParams(void);

/**
 * GetDefaultE2EParams returns a JSON serialized object with all of the E2E
parameters and their default values. Call this function and modify the JSON
to change E2E settings.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsGetDefaultE2EParams(void);

/**
 * GetDefaultE2eFileTransferParams returns a JSON serialized object with all the
E2E file transfer parameters and their default values. Call this function and
modify the JSON to change single use settings.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsGetDefaultE2eFileTransferParams(void);

/**
 * GetDefaultFileTransferParams returns a JSON serialized object with all the
file transfer parameters and their default values. Call this function and
modify the JSON to change file transfer settings.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsGetDefaultFileTransferParams(void);

/**
 * GetDefaultSingleUseParams returns a JSON serialized object with all the
single-use parameters and their default values. Call this function and modify
the JSON to change single use settings.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsGetDefaultSingleUseParams(void);

/**
 * GetDependencies returns the xxdk.DEPENDENCIES.
 */
FOUNDATION_EXPORT NSString* _Nonnull BindingsGetDependencies(void);

/**
 * GetFactsFromContact returns the fact list in the [contact.Contact] object.

Parameters:
 - marshaledContact - the JSON marshalled bytes of [contact.Contact]

Returns:
 - []byte - the JSON marshalled bytes of [fact.FactList]
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsGetFactsFromContact(NSData* _Nullable marshaledContact, NSError* _Nullable* _Nullable error);

/**
 * GetGitVersion returns the xxdk.GITVERSION.
 */
FOUNDATION_EXPORT NSString* _Nonnull BindingsGetGitVersion(void);

/**
 * GetIDFromContact returns the ID in the [contact.Contact] object.

Parameters:
 - marshaledContact - JSON marshalled bytes of [contact.Contact]

Returns:
 - []byte - bytes of the [id.ID] object
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsGetIDFromContact(NSData* _Nullable marshaledContact, NSError* _Nullable* _Nullable error);

/**
 * GetNotificationsReport parses the received notification data to determine which
notifications are for this user. // This returns the JSON-marshalled
NotificationReports.

Parameters:
 - e2eID - e2e object ID in the tracker
 - notificationCSV - the notification data received from the
   notifications' server.
 - marshalledServices - the JSON-marshalled list of services the backend
   keeps track of. Refer to Cmix.TrackServices for information about this.

Returns:
 - []byte - A JSON marshalled NotificationReports. Some NotificationReport's
   within in this structure may have their NotificationReport.ForMe
   set to false. These may be ignored.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsGetNotificationsReport(long e2eId, NSString* _Nullable notificationCSV, NSData* _Nullable marshalledServices, NSError* _Nullable* _Nullable error);

/**
 * GetPubkeyFromContact returns the DH public key in the [contact.Contact]
object.

Parameters:
 - marshaledContact - JSON marshalled bytes of [contact.Contact]

Returns:
 - []byte - JSON marshalled bytes of the [cyclic.Int] object
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsGetPubkeyFromContact(NSData* _Nullable marshaledContact, NSError* _Nullable* _Nullable error);

/**
 * GetVersion returns the xxdk.SEMVER.
 */
FOUNDATION_EXPORT NSString* _Nonnull BindingsGetVersion(void);

/**
 * InitFileTransfer creates a bindings-level file transfer manager.

Parameters:
 - e2eID - e2e object ID in the tracker
 - paramsJSON - JSON marshalled fileTransfer.Params
 */
FOUNDATION_EXPORT BindingsFileTransfer* _Nullable BindingsInitFileTransfer(long e2eID, id<BindingsReceiveFileCallback> _Nullable receiveFileCallback, NSData* _Nullable e2eFileTransferParamsJson, NSData* _Nullable fileTransferParamsJson, NSError* _Nullable* _Nullable error);

/**
 * InitializeBackup creates a bindings-layer Backup object.

Parameters:
 - e2eID - ID of the E2e object in the e2e tracker.
 - udID - ID of the UserDiscovery object in the ud tracker.
 - backupPassPhrase - backup passphrase provided by the user. Used to decrypt
   backup.
 - cb - the callback to be called when a backup is triggered.
 */
FOUNDATION_EXPORT BindingsBackup* _Nullable BindingsInitializeBackup(long e2eID, long udID, NSString* _Nullable backupPassPhrase, id<BindingsUpdateBackupFunc> _Nullable cb, NSError* _Nullable* _Nullable error);

/**
 * IsRegisteredWithUD is a function which checks the internal state
files to determine if a user has registered with UD in the past.

Parameters:
 - e2eID -  REQUIRED. The tracked e2e object ID. This can be retrieved using [E2e.GetID].

Returns:
  - bool - A boolean representing true if the user has been registered with UD already
           or false if it has not been registered already.
 - error - An error should only be returned if the internal tracker failed to retrieve an
           E2e object given the e2eId. If an error was returned, the registration state check
           was not performed properly, and the boolean returned should be ignored.
 */
FOUNDATION_EXPORT BOOL BindingsIsRegisteredWithUD(long e2eId, BOOL* _Nullable ret0_, NSError* _Nullable* _Nullable error);

/**
 * Listen starts a single-use listener on a given tag using the passed in E2e
object and SingleUseCallback func.

Parameters:
 - e2eID - ID of the e2e object in the tracker
 - tag - identifies the single-use message
 - cb - the callback that will be called when a response is received

Returns:
 - Stopper - an interface containing a function used to stop the listener
 */
FOUNDATION_EXPORT id<BindingsStopper> _Nullable BindingsListen(long e2eID, NSString* _Nullable tag, id<BindingsSingleUseCallback> _Nullable cb, NSError* _Nullable* _Nullable error);

/**
 * LoadCmix will load an existing user storage from the storageDir using the
password. This will fail if the user storage does not exist or the password
is incorrect.

The password is passed as a byte array so that it can be cleared from memory
and stored as securely as possible using the MemGuard library.

LoadCmix does not block on network connection and instead loads and starts
subprocesses to perform network operations.
 */
FOUNDATION_EXPORT BindingsCmix* _Nullable BindingsLoadCmix(NSString* _Nullable storageDir, NSData* _Nullable password, NSData* _Nullable cmixParamsJSON, NSError* _Nullable* _Nullable error);

/**
 * LoadReceptionIdentity loads the given identity in Cmix storage with the given
key.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsLoadReceptionIdentity(NSString* _Nullable key, long cmixId, NSError* _Nullable* _Nullable error);

/**
 * LogLevel sets level of logging. All logs at the set level and below will be
displayed (e.g., when log level is ERROR, only ERROR, CRITICAL, and FATAL
messages will be printed).

Log level options:
	TRACE    - 0
	DEBUG    - 1
	INFO     - 2
	WARN     - 3
	ERROR    - 4
	CRITICAL - 5
	FATAL    - 6

The default log level without updates is INFO.
 */
FOUNDATION_EXPORT BOOL BindingsLogLevel(long level, NSError* _Nullable* _Nullable error);

/**
 * Login creates and returns a new E2e object and adds it to the
e2eTrackerSingleton. Identity should be created via
Cmix.MakeReceptionIdentity and passed in here. If callbacks is left nil, a
default auth.Callbacks will be used.
 */
FOUNDATION_EXPORT BindingsE2e* _Nullable BindingsLogin(long cmixId, id<BindingsAuthCallbacks> _Nullable callbacks, NSData* _Nullable identity, NSData* _Nullable e2eParamsJSON, NSError* _Nullable* _Nullable error);

/**
 * LoginEphemeral creates and returns a new ephemeral E2e object and adds it to
the e2eTrackerSingleton. Identity should be created via
Cmix.MakeReceptionIdentity or Cmix.MakeLegacyReceptionIdentity and passed in
here. If callbacks is left nil, a default auth.Callbacks will be used.
 */
FOUNDATION_EXPORT BindingsE2e* _Nullable BindingsLoginEphemeral(long cmixId, id<BindingsAuthCallbacks> _Nullable callbacks, NSData* _Nullable identity, NSData* _Nullable e2eParamsJSON, NSError* _Nullable* _Nullable error);

/**
 * LookupUD returns the public key of the passed ID as known by the user
discovery system or returns by the timeout.

Parameters:
 - e2eID - e2e object ID in the tracker
 - udContact - the marshalled bytes of the contact.Contact object
 - lookupId - the marshalled bytes of the id.ID object for the user that
   LookupUD will look up.
 - singleRequestParams - the JSON marshalled bytes of single.RequestParams

Returns:
 - []byte - the JSON marshalled bytes of the SingleUseSendReport object,
   which can be passed into Cmix.WaitForRoundResult to see if the send
   succeeded.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsLookupUD(long e2eID, NSData* _Nullable udContact, id<BindingsUdLookupCallback> _Nullable cb, NSData* _Nullable lookupId, NSData* _Nullable singleRequestParamsJSON, NSError* _Nullable* _Nullable error);

/**
 * NewBroadcastChannel creates a bindings-layer broadcast channel and starts
listening for new messages.

Parameters:
 - cmixId - internal ID of cmix
 - channelDefinition - JSON marshalled ChannelDef object
 */
FOUNDATION_EXPORT BindingsChannel* _Nullable BindingsNewBroadcastChannel(long cmixId, NSData* _Nullable channelDefinition, NSError* _Nullable* _Nullable error);

/**
 * NewCmix creates user storage, generates keys, connects, and registers with
the network. Note that this does not register a username/identity, but merely
creates a new cryptographic identity for adding such information at a later
date.

Users of this function should delete the storage directory on error.
 */
FOUNDATION_EXPORT BOOL BindingsNewCmix(NSString* _Nullable ndfJSON, NSString* _Nullable storageDir, NSData* _Nullable password, NSString* _Nullable registrationCode, NSError* _Nullable* _Nullable error);

/**
 * NewCmixFromBackup initializes a new e2e storage from an encrypted
backup. Users of this function should delete the storage directory on error.
Users of this function should call LoadCmix as normal once this call succeeds.

Parameters:
 - ndfJSON - JSON of the NDF.
 - storageDir - directory for the storage files.
 - sessionPassword - password to decrypt the data in the storageDir.
 - backupPassphrase - backup passphrase provided by the user. Used to decrypt backup.
 - backupFileContents - the file contents of the backup.

Returns:
 - []byte - the JSON marshalled bytes of the BackupReport object.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsNewCmixFromBackup(NSString* _Nullable ndfJSON, NSString* _Nullable storageDir, NSString* _Nullable backupPassphrase, NSData* _Nullable sessionPassword, NSData* _Nullable backupFileContents, NSError* _Nullable* _Nullable error);

/**
 * NewDummyTrafficManager creates a DummyTraffic manager and initialises the
dummy traffic sending thread. Note that the manager does not start sending
dummy traffic until true is passed into DummyTraffic.SetStatus. The time
duration between each sending operation and the amount of messages sent each
interval are randomly generated values with bounds defined by the given
parameters below.

Parameters:
 - cmixId - a Cmix object ID in the tracker.
 - maxNumMessages - the upper bound of the random number of messages sent
   each sending cycle.
 - avgSendDeltaMS - the average duration, in milliseconds, to wait between
   sends.
 - randomRangeMS - the upper bound of the interval between sending cycles, in
   milliseconds. Sends occur every avgSendDeltaMS +/- a random duration with
   an upper bound of randomRangeMS.
 */
FOUNDATION_EXPORT BindingsDummyTraffic* _Nullable BindingsNewDummyTrafficManager(long cmixId, long maxNumMessages, long avgSendDeltaMS, long randomRangeMS, NSError* _Nullable* _Nullable error);

/**
 * NewGroupChat creates a bindings-layer group chat manager.

Parameters:
 - e2eID - e2e object ID in the tracker.
 - requestFunc - a callback to handle group chat requests.
 - processor - the group chat message processor.
 */
FOUNDATION_EXPORT BindingsGroupChat* _Nullable BindingsNewGroupChat(long e2eID, id<BindingsGroupRequest> _Nullable requestFunc, id<BindingsGroupChatProcessor> _Nullable processor, NSError* _Nullable* _Nullable error);

/**
 * NewOrLoadUd loads an existing UserDiscovery from storage or creates a new
UserDiscovery if there is no storage data. Regardless of storage state,
the UserDiscovery object returned will be registered with the
User Discovery service. If the user is not already registered, a call
to register will occur internally. If the user is already registered,
this call will simply load state and return to you a UserDiscovery object.
Some parameters are required for registering with the service, but are not required
if the user is already registered. These will be noted in the parameters section as
"SEMI-REQUIRED".

Certain parameters are required every call to this function. These parameters are listed below
as "REQUIRED". For example, parameters need be provided to specify how to connect to the
User Discovery service. These parameters specifically may be used to contact either the UD
server hosted by the xx network team or a custom third-party operated server. For the former,
all the information may be fetched from the NDF using the bindings. These fetch
methods are detailed in the parameters section.

Params
 - e2eID -  REQUIRED. The tracked e2e object ID. This is returned by [E2e.GetID].
 - follower - REQUIRED. Network follower function. This will check if the network
   follower is running.
 - username - SEMI-REQUIRED. The username the user wants to register with UD.
   If the user is already registered, this field may be blank. If the user is not
   already registered, these field must be populated with a username that meets the
   requirements of the UD service. For example, in the xx network's UD service,
   the username must not be registered by another user.
 - registrationValidationSignature - SEMI-REQUIRED. A signature provided by the xx network
   (i.e. the client registrar). If the user is not already registered, this field is required
   in order to register with the xx network. This may be nil if the user is already registered
   or connecting to a third-party UD service unassociated with the xx network.
 - cert - REQUIRED. The TLS certificate for the UD server this call will connect with.
   If this is nil, you may not contact the UD server hosted by the xx network.
   Third-party services may vary.
   You may use the UD server run by the xx network team by using [E2e.GetUdCertFromNdf].
 - contactFile - REQUIRED. The data within a marshalled [contact.Contact]. This represents the
   contact file of the server this call will connect with.
   If this is nil, you may not contact the UD server hosted by the xx network.
   Third-party services may vary.
   You may use the UD server run by the xx network team by using [E2e.GetUdContactFromNdf].
 - address - REQUIRED. The IP address of the UD server this call will connect with.
   You may use the UD server run by the xx network team by using [E2e.GetUdAddressFromNdf].
   If this is nil, you may not contact the UD server hosted by the xx network.
   Third-party services may vary.

Returns
 - A Manager object which is registered to the specified UD service.
 */
FOUNDATION_EXPORT BindingsUserDiscovery* _Nullable BindingsNewOrLoadUd(long e2eID, id<BindingsUdNetworkStatus> _Nullable follower, NSString* _Nullable username, NSData* _Nullable registrationValidationSignature, NSData* _Nullable cert, NSData* _Nullable contactFile, NSString* _Nullable address, NSError* _Nullable* _Nullable error);

/**
 * NewUdManagerFromBackup builds a new user discover manager from a backup. It
will construct a manager that is already registered and restore already
registered facts into store.

Parameters:
 - e2eID - e2e object ID in the tracker
 - follower - network follower func wrapped in UdNetworkStatus
 - username - The username this user registered with initially. This should
              not be nullable, and be JSON marshalled as retrieved from
              UserDiscovery.GetFacts().
 - emailFactJson - nullable JSON marshalled email [fact.Fact]
 - phoneFactJson - nullable JSON marshalled phone [fact.Fact]
 - cert - the TLS certificate for the UD server this call will connect with.
   You may use the UD server run by the xx network team by using
   E2e.GetUdCertFromNdf.
 - contactFile - the data within a marshalled contact.Contact. This
   represents the contact file of the server this call will connect with. You
   may use the UD server run by the xx network team by using
   E2e.GetUdContactFromNdf.
 - address - the IP address of the UD server this call will connect with. You
   may use the UD server run by the xx network team by using
   E2e.GetUdAddressFromNdf.
 */
FOUNDATION_EXPORT BindingsUserDiscovery* _Nullable BindingsNewUdManagerFromBackup(long e2eID, id<BindingsUdNetworkStatus> _Nullable follower, NSData* _Nullable usernameJson, NSData* _Nullable emailFactJson, NSData* _Nullable phoneFactJson, NSData* _Nullable cert, NSData* _Nullable contactFile, NSString* _Nullable address, NSError* _Nullable* _Nullable error);

/**
 * RegisterForNotifications allows a client to register for push notifications.
The token is a firebase messaging token.

Parameters:
 - e2eId - ID of the E2E object in the E2E tracker
 */
FOUNDATION_EXPORT BOOL BindingsRegisterForNotifications(long e2eId, NSString* _Nullable token, NSError* _Nullable* _Nullable error);

/**
 * RegisterLogWriter registers a callback on which logs are written.
 */
FOUNDATION_EXPORT void BindingsRegisterLogWriter(id<BindingsLogWriter> _Nullable writer);

/**
 * RequestRestLike sends a restlike request to a given contact.

Parameters:
 - e2eID - ID of the e2e object in the tracker
 - recipient - marshalled contact.Contact object
 - request - JSON marshalled RestlikeMessage
 - paramsJSON - JSON marshalled single.RequestParams

Returns:
 - []byte - JSON marshalled restlike.Message
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsRequestRestLike(long e2eID, NSData* _Nullable recipient, NSData* _Nullable request, NSData* _Nullable paramsJSON, NSError* _Nullable* _Nullable error);

/**
 * RestlikeRequest performs a normal restlike request.

Parameters:
 - cmixId - ID of the cMix object in the tracker
 - connectionID - ID of the connection in the tracker
 - request - JSON marshalled RestlikeMessage
 - e2eParamsJSON - JSON marshalled xxdk.E2EParams

Returns:
 - []byte - JSON marshalled RestlikeMessage
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsRestlikeRequest(long cmixId, long connectionID, NSData* _Nullable request, NSData* _Nullable e2eParamsJSON, NSError* _Nullable* _Nullable error);

/**
 * RestlikeRequestAuth performs an authenticated restlike request.

Parameters:
 - cmixId - ID of the cMix object in the tracker
 - authConnectionID - ID of the authenticated connection in the tracker
 - request - JSON marshalled RestlikeMessage
 - e2eParamsJSON - JSON marshalled xxdk.E2EParams

Returns:
 - []byte - JSON marshalled RestlikeMessage
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsRestlikeRequestAuth(long cmixId, long authConnectionID, NSData* _Nullable request, NSData* _Nullable e2eParamsJSON, NSError* _Nullable* _Nullable error);

/**
 * ResumeBackup resumes the backup processes with a new callback.
Call this function only when resuming a backup that has already been
initialized or to replace the callback.
To start the backup for the first time or to use a new password, use
InitializeBackup.

Parameters:
 - e2eID - ID of the E2e object in the e2e tracker.
 - udID - ID of the UserDiscovery object in the ud tracker.
 - cb - the callback to be called when a backup is triggered.
   This will replace any callback that has been passed into InitializeBackup.
 */
FOUNDATION_EXPORT BindingsBackup* _Nullable BindingsResumeBackup(long e2eID, long udID, id<BindingsUpdateBackupFunc> _Nullable cb, NSError* _Nullable* _Nullable error);

/**
 * SearchUD searches user discovery for the passed Facts. The searchCallback
will return a list of contacts, each having the facts it hit against. This is
NOT intended to be used to search for multiple users at once; that can have a
privacy reduction. Instead, it is intended to be used to search for a user
where multiple pieces of information is known.

Parameters:
 - e2eID - e2e object ID in the tracker
 - udContact - the marshalled bytes of the contact.Contact for the user
   discovery server
 - factListJSON - the JSON marshalled bytes of [fact.FactList]
 - singleRequestParams - the JSON marshalled bytes of single.RequestParams

Returns:
 - []byte - the JSON marshalled bytes of the SingleUseSendReport object,
   which can be passed into Cmix.WaitForRoundResult to see if the send
   operation succeeded.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsSearchUD(long e2eID, NSData* _Nullable udContact, id<BindingsUdSearchCallback> _Nullable cb, NSData* _Nullable factListJSON, NSData* _Nullable singleRequestParamsJSON, NSError* _Nullable* _Nullable error);

/**
 * SetDashboardURL is a function which modifies the base dashboard URL
that is returned as part of any send report. Internally, this is defaulted
to "https://dashboard.xx.network". This should only be called if the user
explicitly wants to modify the dashboard URL. This function is not
thread-safe, and as such should only be called on setup.

Parameters:
 - newURL - A valid URL that will be used for round look up on any send
   report.
 */
FOUNDATION_EXPORT void BindingsSetDashboardURL(NSString* _Nullable newURL);

/**
 * SetFactsOnContact replaces the facts on the contact with the passed in facts
pass in empty facts in order to clear the facts.

Parameters:
 - marshaledContact - the JSON marshalled bytes of [contact.Contact]
 - factListJSON - the JSON marshalled bytes of [fact.FactList]

Returns:
 - []byte - marshalled bytes of the modified [contact.Contact]
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsSetFactsOnContact(NSData* _Nullable marshaledContact, NSData* _Nullable factListJSON, NSError* _Nullable* _Nullable error);

/**
 * StoreReceptionIdentity stores the given identity in Cmix storage with the
given key. This is the ideal way to securely store identities, as the caller
of this function is only required to store the given key separately rather
than the keying material.
 */
FOUNDATION_EXPORT BOOL BindingsStoreReceptionIdentity(NSString* _Nullable key, NSData* _Nullable identity, long cmixId, NSError* _Nullable* _Nullable error);

/**
 * TransmitSingleUse transmits payload to recipient via single-use.

Parameters:
 - e2eID - ID of the e2e object in the tracker
 - recipient - marshalled contact.Contact object
 - tag - identifies the single-use message
 - payload - message contents
 - paramsJSON - JSON marshalled single.RequestParams
 - responseCB - the callback that will be called when a response is received

Returns:
 - []byte - the JSON marshalled bytes of the SingleUseSendReport object,
   which can be passed into WaitForRoundResult to see if the send succeeded.
 */
FOUNDATION_EXPORT NSData* _Nullable BindingsTransmitSingleUse(long e2eID, NSData* _Nullable recipient, NSString* _Nullable tag, NSData* _Nullable payload, NSData* _Nullable paramsJSON, id<BindingsSingleUseResponse> _Nullable responseCB, NSError* _Nullable* _Nullable error);

/**
 * UnregisterForNotifications turns off notifications for this client.

Parameters:
 - e2eId - ID of the E2E object in the E2E tracker
 */
FOUNDATION_EXPORT BOOL BindingsUnregisterForNotifications(long e2eId, NSError* _Nullable* _Nullable error);

/**
 * UpdateCommonErrors updates the internal error mapping database. This internal
database maps errors returned from the backend to user-friendly error
messages.

Parameters:
 - jsonFile - contents of a JSON file whose format conforms to the example below.

Example Input:
 {
   "Failed to Unmarshal Conversation": "Could not retrieve conversation",
   "Failed to unmarshal SentRequestMap": "Failed to pull up friend requests",
   "cannot create username when network is not health": "Cannot create username, unable to connect to network",
 }
 */
FOUNDATION_EXPORT BOOL BindingsUpdateCommonErrors(NSString* _Nullable jsonFile, NSError* _Nullable* _Nullable error);

@class BindingsAuthCallbacks;

@class BindingsBroadcastListener;

@class BindingsClientError;

@class BindingsFileTransferReceiveProgressCallback;

@class BindingsFileTransferSentProgressCallback;

@class BindingsGroupChatProcessor;

@class BindingsGroupRequest;

@class BindingsListener;

@class BindingsLogWriter;

@class BindingsMessageDeliveryCallback;

@class BindingsNetworkHealthCallback;

@class BindingsProcessor;

@class BindingsReceiveFileCallback;

@class BindingsReporterFunc;

@class BindingsRestlikeCallback;

@class BindingsSingleUseCallback;

@class BindingsSingleUseResponse;

@class BindingsStopper;

@class BindingsTrackServicesCallback;

@class BindingsUdLookupCallback;

@class BindingsUdNetworkStatus;

@class BindingsUdSearchCallback;

@class BindingsUpdateBackupFunc;

/**
 * AuthCallbacks is the bindings-specific interface for auth.Callbacks methods.
 */
@interface BindingsAuthCallbacks : NSObject <goSeqRefInterface, BindingsAuthCallbacks> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)confirm:(NSData* _Nullable)contact receptionId:(NSData* _Nullable)receptionId ephemeralId:(int64_t)ephemeralId roundId:(int64_t)roundId;
- (void)request:(NSData* _Nullable)contact receptionId:(NSData* _Nullable)receptionId ephemeralId:(int64_t)ephemeralId roundId:(int64_t)roundId;
- (void)reset:(NSData* _Nullable)contact receptionId:(NSData* _Nullable)receptionId ephemeralId:(int64_t)ephemeralId roundId:(int64_t)roundId;
@end

/**
 * BroadcastListener is the public function type bindings can use to listen for
broadcast messages.

Parameters:
 - []byte - the JSON marshalled bytes of the BroadcastMessage object, which
   can be passed into WaitForRoundResult to see if the broadcast succeeded.
 */
@interface BindingsBroadcastListener : NSObject <goSeqRefInterface, BindingsBroadcastListener> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)callback:(NSData* _Nullable)p0 p1:(NSError* _Nullable)p1;
@end

@interface BindingsClientError : NSObject <goSeqRefInterface, BindingsClientError> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)report:(NSString* _Nullable)source message:(NSString* _Nullable)message trace:(NSString* _Nullable)trace;
@end

/**
 * FileTransferReceiveProgressCallback is a bindings-layer interface that is
called with the progress of a received file.
 */
@interface BindingsFileTransferReceiveProgressCallback : NSObject <goSeqRefInterface, BindingsFileTransferReceiveProgressCallback> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
/**
 * Callback is called when a file part is sent or an error occurs.

Parameters:
 - payload - the JSON marshalled bytes of a Progress object.
 - t - tracker that allows the lookup of the status of any file part
 - err - any errors that occurred during sending
 */
- (void)callback:(NSData* _Nullable)payload t:(BindingsFilePartTracker* _Nullable)t err:(NSError* _Nullable)err;
@end

/**
 * FileTransferSentProgressCallback is a bindings-layer interface that contains
a callback that is called when the sent progress updates.
 */
@interface BindingsFileTransferSentProgressCallback : NSObject <goSeqRefInterface, BindingsFileTransferSentProgressCallback> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
/**
 * Callback is called when a file part is sent or an error occurs.

Parameters:
 - payload - the JSON marshalled bytes of a Progress object.
 - t - tracker that allows the lookup of the status of any file part
 - err - any errors that occurred during sending
 */
- (void)callback:(NSData* _Nullable)payload t:(BindingsFilePartTracker* _Nullable)t err:(NSError* _Nullable)err;
@end

/**
 * GroupChatProcessor manages the handling of received group chat messages.
The decryptedMessage field will be a JSON marshalled GroupChatMessage.
 */
@interface BindingsGroupChatProcessor : NSObject <goSeqRefInterface, BindingsGroupChatProcessor> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)process:(NSData* _Nullable)decryptedMessage msg:(NSData* _Nullable)msg receptionId:(NSData* _Nullable)receptionId ephemeralId:(int64_t)ephemeralId roundId:(int64_t)roundId err:(NSError* _Nullable)err;
- (NSString* _Nonnull)string;
@end

/**
 * GroupRequest is a bindings-layer interface that handles a group reception.

Parameters:
 - trackedGroupId - a bindings layer Group object.
 */
@interface BindingsGroupRequest : NSObject <goSeqRefInterface, BindingsGroupRequest> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)callback:(BindingsGroup* _Nullable)g;
@end

/**
 * Listener provides a callback to hear a message.

An object implementing this interface can be called back when the client gets
a message of the type that the registerer specified at registration time.
 */
@interface BindingsListener : NSObject <goSeqRefInterface, BindingsListener> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
/**
 * Hear is called to receive a message in the UI.

Parameters:
 - item - JSON marshalled Message object
 */
- (void)hear:(NSData* _Nullable)item;
/**
 * Name returns a name; used for debugging.
 */
- (NSString* _Nonnull)name;
@end

@interface BindingsLogWriter : NSObject <goSeqRefInterface, BindingsLogWriter> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)log:(NSString* _Nullable)p0;
@end

/**
 * MessageDeliveryCallback gets called on the determination if all events
related to a message send were successful.

If delivered == true, timedOut == false && roundResults != nil

If delivered == false, roundResults == nil

If timedOut == true, delivered == false && roundResults == nil
 */
@interface BindingsMessageDeliveryCallback : NSObject <goSeqRefInterface, BindingsMessageDeliveryCallback> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)eventCallback:(BOOL)delivered timedOut:(BOOL)timedOut roundResults:(NSData* _Nullable)roundResults;
@end

/**
 * NetworkHealthCallback contains a callback that is used to receive
notification if network health changes.
 */
@interface BindingsNetworkHealthCallback : NSObject <goSeqRefInterface, BindingsNetworkHealthCallback> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)callback:(BOOL)p0;
@end

/**
 * Processor is the bindings-specific interface for message.Processor methods.
 */
@interface BindingsProcessor : NSObject <goSeqRefInterface, BindingsProcessor> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)process:(NSData* _Nullable)message receptionId:(NSData* _Nullable)receptionId ephemeralId:(int64_t)ephemeralId roundId:(int64_t)roundId;
- (NSString* _Nonnull)string;
@end

/**
 * ReceiveFileCallback is a bindings-layer interface that contains a callback
that is called when a file is received.
 */
@interface BindingsReceiveFileCallback : NSObject <goSeqRefInterface, BindingsReceiveFileCallback> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
/**
 * Callback is called when a new file transfer is received.

Parameters:
 - payload - the JSON marshalled bytes of a ReceivedFile object.
 - err - any errors that occurred during reception
 */
- (void)callback:(NSData* _Nullable)payload err:(NSError* _Nullable)err;
@end

/**
 * ReporterFunc is a bindings-layer interface that receives info from the Event
Manager.

Parameters:
 - payload - JSON marshalled EventReport object
 */
@interface BindingsReporterFunc : NSObject <goSeqRefInterface, BindingsReporterFunc> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)report:(NSData* _Nullable)payload err:(NSError* _Nullable)err;
@end

/**
 * RestlikeCallback is the public function type bindings can use to make an
asynchronous restlike request.

Parameters:
 - []byte - JSON marshalled restlike.Message
 - error - an error (the results of calling json.Marshal on the message)
 */
@interface BindingsRestlikeCallback : NSObject <goSeqRefInterface, BindingsRestlikeCallback> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)callback:(NSData* _Nullable)p0 p1:(NSError* _Nullable)p1;
@end

/**
 * SingleUseCallback func is passed into Listen and called when messages are
received.

Parameters:
 - callbackReport - the JSON marshalled bytes of the SingleUseCallbackReport
   object, which can be passed into Cmix.WaitForRoundResult to see if the
   send operation succeeded.
 */
@interface BindingsSingleUseCallback : NSObject <goSeqRefInterface, BindingsSingleUseCallback> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)callback:(NSData* _Nullable)callbackReport err:(NSError* _Nullable)err;
@end

/**
 * SingleUseResponse is the public facing callback function passed by bindings
clients into TransmitSingleUse.

Parameters:
 - callbackReport - the JSON marshalled bytes of the SingleUseResponseReport
   object, which can be passed into Cmix.WaitForRoundResult to see if the
   send operation succeeded.
 */
@interface BindingsSingleUseResponse : NSObject <goSeqRefInterface, BindingsSingleUseResponse> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)callback:(NSData* _Nullable)responseReport err:(NSError* _Nullable)err;
@end

/**
 * Stopper is a public interface returned by Listen, allowing users to stop the
registered listener.
 */
@interface BindingsStopper : NSObject <goSeqRefInterface, BindingsStopper> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)stop;
@end

/**
 * TrackServicesCallback is the callback for [Cmix.TrackServices].
This will pass to the user a JSON-marshalled list of backend services.
If there was an error retrieving or marshalling the service list,
there is an error for the second parameter which will be non-null.

Parameters:
 - marshalData - JSON marshalled bytes of [message.ServiceList], which is an
   array of [id.ID] and [message.Service].
 - err - JSON unmarshalling error

Example JSON:
 [
   {
     "Id": "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD", // bytes of id.ID encoded as base64 string
     "Services": [
       {
         "Identifier": "AQID",                             // bytes encoded as base64 string
         "Tag": "TestTag 1",                               // string
         "Metadata": "BAUG"                                // bytes encoded as base64 string
       }
     ]
   },
   {
     "Id": "AAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD",
     "Services": [
       {
         "Identifier": "AQID",
         "Tag": "TestTag 2",
         "Metadata": "BAUG"
       }
     ]
   },
 ]
 */
@interface BindingsTrackServicesCallback : NSObject <goSeqRefInterface, BindingsTrackServicesCallback> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)callback:(NSData* _Nullable)marshalData err:(NSError* _Nullable)err;
@end

/**
 * UdLookupCallback contains the callback called by LookupUD that returns the
contact that matches the passed in ID.

Parameters:
 - contactBytes - the marshalled bytes of contact.Contact returned from the
   lookup, or nil if an error occurs
 - err - any errors that occurred in the lookup
 */
@interface BindingsUdLookupCallback : NSObject <goSeqRefInterface, BindingsUdLookupCallback> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)callback:(NSData* _Nullable)contactBytes err:(NSError* _Nullable)err;
@end

/**
 * UdNetworkStatus contains the UdNetworkStatus, which is a bindings-level
interface for ud.udNetworkStatus.
 */
@interface BindingsUdNetworkStatus : NSObject <goSeqRefInterface, BindingsUdNetworkStatus> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
/**
 * UdNetworkStatus returns:
- int - a xxdk.Status int
 */
- (long)udNetworkStatus;
@end

/**
 * UdSearchCallback contains the callback called by SearchUD that returns a list
of contact.Contact objects  that match the list of facts passed into
SearchUD.

Parameters:
 - contactListJSON - the JSON marshalled bytes of []contact.Contact, or nil
   if an error occurs.

  JSON Example:
  {
 	"<xxc(2)F8dL9EC6gy+RMJuk3R+Au6eGExo02Wfio5cacjBcJRwDEgB7Ugdw/BAr6RkCABkWAFV1c2VybmFtZTA7c4LzV05sG+DMt+rFB0NIJg==xxc>",
 	"<xxc(2)eMhAi/pYkW5jCmvKE5ZaTglQb+fTo1D8NxVitr5CCFADEgB7Ugdw/BAr6RoCABkWAFV1c2VybmFtZTE7fElAa7z3IcrYrrkwNjMS2w==xxc>",
 	"<xxc(2)d7RJTu61Vy1lDThDMn8rYIiKSe1uXA/RCvvcIhq5Yg4DEgB7Ugdw/BAr6RsCABkWAFV1c2VybmFtZTI7N3XWrxIUpR29atpFMkcR6A==xxc>"
	}
 - err - any errors that occurred in the search.
 */
@interface BindingsUdSearchCallback : NSObject <goSeqRefInterface, BindingsUdSearchCallback> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)callback:(NSData* _Nullable)contactListJSON err:(NSError* _Nullable)err;
@end

/**
 * UpdateBackupFunc contains a function callback that returns new backups.
 */
@interface BindingsUpdateBackupFunc : NSObject <goSeqRefInterface, BindingsUpdateBackupFunc> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)updateBackup:(NSData* _Nullable)encryptedBackup;
@end

#endif
